/*
 * Decompiled with CFR 0.152.
 */
package jace.apple2e;

import jace.config.ConfigurableField;
import jace.core.CPU;
import jace.core.Computer;
import jace.core.RAM;

public class MOS65C02
extends CPU {
    private static MOS65C02 cpu;
    private static RAM ram;
    static int RESET_VECTOR;
    static int INT_VECTOR;
    @ConfigurableField(name="Accumulator")
    public int A = 255;
    @ConfigurableField(name="X Register")
    public int X = 255;
    @ConfigurableField(name="Y Register")
    public int Y = 255;
    @ConfigurableField(name="Carry flag", description="(must be 0 or 1)")
    public int C = 1;
    @ConfigurableField(name="Zero flag")
    public boolean Z = true;
    @ConfigurableField(name="Interrupt flag")
    public boolean I = true;
    @ConfigurableField(name="Decimal flag")
    public boolean D = true;
    @ConfigurableField(name="Break flag")
    public boolean B = true;
    @ConfigurableField(name="Overflow flag")
    public boolean V = true;
    @ConfigurableField(name="Negative flag")
    public boolean N = true;
    @ConfigurableField(name="Stack pointer")
    public int STACK = 255;
    private static OPCODE[] opcodes;
    private boolean pageBoundaryPenalty = false;

    public void reconfigure() {
    }

    public MOS65C02() {
        this.setHalt(true);
        cpu = this;
        this.reconfigure();
    }

    protected void executeOpcode() {
        int op;
        OPCODE opcode;
        int pc = this.getProgramCounter();
        if (this.isTraceEnabled()) {
            System.out.println(this.getState().toUpperCase() + "  " + Integer.toString(pc, 16) + " : " + this.disassemble());
        }
        if ((opcode = opcodes[op = 0xFF & ram.read(pc, true)]) != null) {
            int address = opcode.getMode().calcAddress();
            this.incrementProgramCounter(opcode.getMode().getSize());
            boolean triggerReadListener = !opcode.getCommand().isStoreOnly();
            int value = address > -1 ? 0xFF & ram.read(address, triggerReadListener) : 0;
            opcode.call(address, value);
            this.addWaitCycles(opcode.getWaitCycles());
            return;
        }
        System.out.println("Unrecognized opcode " + Integer.toString(op, 16) + " at " + Integer.toString(pc, 16));
        this.incrementProgramCounter(1);
    }

    private void setNZ(int value) {
        this.N = (value & 0x80) != 0;
        this.Z = (value & 0xFF) == 0;
    }

    private void pushWord(int val) {
        this.push((byte)(val >> 8));
        this.push((byte)(val & 0xFF));
    }

    private int popWord() {
        return 0xFF & this.pop() | 0xFF00 & this.pop() << 8;
    }

    private void push(byte val) {
        ram.write(256 + this.STACK, val, true);
        this.STACK = this.STACK - 1 & 0xFF;
    }

    private byte pop() {
        this.STACK = this.STACK + 1 & 0xFF;
        byte val = ram.read(256 + this.STACK, true);
        return val;
    }

    private byte getStatus() {
        return (byte)((this.N ? 128 : 0) | (this.V ? 64 : 0) | 0x20 | (this.B ? 16 : 0) | (this.D ? 8 : 0) | (this.I ? 4 : 0) | (this.Z ? 2 : 0) | (this.C > 0 ? 1 : 0));
    }

    private void setStatus(byte b) {
        this.N = (b & 0x80) != 0;
        this.V = (b & 0x40) != 0;
        this.B = (b & 0x10) != 0;
        this.D = (b & 8) != 0;
        this.I = (b & 4) != 0;
        this.Z = (b & 2) != 0;
        this.C = (char)(b & 1);
    }

    private void returnFromInterrupt() {
        this.setStatus(this.pop());
        this.B = false;
        this.setProgramCounter(this.popWord());
    }

    private void waitForInterrupt() {
        this.B = true;
        this.I = true;
        this.setHalt(true);
    }

    public void BRK() {
        System.out.println("BRK at $" + Integer.toString(this.getProgramCounter(), 16));
        this.I = true;
        this.incrementProgramCounter(1);
        this.processInterrupt(true);
    }

    public void processInterrupt() {
        this.processInterrupt(false);
    }

    public void processInterrupt(boolean BRK) {
        this.B = BRK;
        if (this.I) {
            this.setHalt(false);
            this.pushWord(this.getProgramCounter());
            this.push(this.getStatus());
            int newPC = ram.readWord(INT_VECTOR, true);
            System.out.println("Interrupt generated, setting PC to (" + Integer.toString(INT_VECTOR, 16) + ") = " + Integer.toString(newPC, 16));
            this.setProgramCounter(newPC);
        }
    }

    public int getSTACK() {
        return this.STACK;
    }

    public void reset() {
        this.setHalt(true);
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.pushWord(this.getProgramCounter());
        this.push(this.getStatus());
        this.B = true;
        this.D = false;
        int newPC = ram.readWord(RESET_VECTOR, true);
        System.out.println("Reset called, setting PC to (" + Integer.toString(RESET_VECTOR, 16) + ") = " + Integer.toString(newPC, 16));
        this.setProgramCounter(newPC);
        this.resume();
    }

    public void generateInterrupt() {
        this.B = false;
        this.processInterrupt();
    }

    protected String getDeviceName() {
        return "65C02 Processor";
    }

    private String byte2(int b) {
        String out = Integer.toString(b & 0xFF, 16);
        if (out.length() == 1) {
            return "0" + out;
        }
        return out;
    }

    private String wordString(int w) {
        String out = Integer.toString(w, 16);
        if (out.length() == 1) {
            return "000" + out;
        }
        if (out.length() == 2) {
            return "00" + out;
        }
        if (out.length() == 3) {
            return "0" + out;
        }
        return out;
    }

    public String getState() {
        String out = "";
        out = out + this.byte2(this.A) + " ";
        out = out + this.byte2(this.X) + " ";
        out = out + this.byte2(this.Y) + " ";
        out = out + "01" + this.byte2(this.STACK) + " ";
        out = out + (this.N ? "N" : ".");
        out = out + (this.V ? "V" : ".");
        out = out + "R";
        out = out + (this.B ? "B" : ".");
        out = out + (this.D ? "D" : ".");
        out = out + (this.I ? "I" : ".");
        out = out + (this.Z ? "Z" : ".");
        out = out + (this.C != 0 ? "C" : ".");
        return out;
    }

    public String disassemble() {
        int pc = this.getProgramCounter();
        byte op = ram.read(pc, false);
        OPCODE o = opcodes[op & 0xFF];
        if (o == null) {
            return "???";
        }
        int b1 = 0xFF & ram.read(pc + 1 & 0xFFFF, false);
        int b2 = 0xFF & ram.read(pc + 2 & 0xFFFF, false);
        String format = o.getMode().format;
        String R = this.wordString(pc + 2 + (byte)b1);
        format = format.replaceAll("~1", this.byte2(b1));
        format = format.replaceAll("~2", this.byte2(b2));
        format = format.replaceAll("R", R);
        return o.getCommand().toString() + " " + format;
    }

    private void setPageBoundaryPenalty(boolean b) {
        this.pageBoundaryPenalty = b;
    }

    public void pushPC() {
        cpu.pushWord(cpu.getProgramCounter() - 1);
    }

    static {
        ram = Computer.getComputer().getMemory();
        RESET_VECTOR = 65532;
        INT_VECTOR = 65534;
        opcodes = new OPCODE[256];
        OPCODE[] arr$ = OPCODE.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            OPCODE o;
            MOS65C02.opcodes[o.getValue()] = o = arr$[i$];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum COMMAND {
        ADC(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                int w = 0;
                boolean bl = cpu.V = ((cpu.A ^ value) & 0x80) == 0;
                if (cpu.D) {
                    w = (cpu.A & 0xF) + (value & 0xF) + cpu.C;
                    if (w >= 10) {
                        w = 0x10 | w + 6 & 0xF;
                    }
                    if ((w += (cpu.A & 0xF0) + (value & 0xF0)) >= 160) {
                        cpu.C = 1;
                        if (cpu.V && w >= 384) {
                            cpu.V = false;
                        }
                        w += 96;
                    } else {
                        cpu.C = 0;
                        if (cpu.V && w < 128) {
                            cpu.V = false;
                        }
                    }
                } else {
                    w = cpu.A + value + cpu.C;
                    if (w >= 256) {
                        cpu.C = 1;
                        if (cpu.V && w >= 384) {
                            cpu.V = false;
                        }
                    } else {
                        cpu.C = 0;
                        if (cpu.V && w < 128) {
                            cpu.V = false;
                        }
                    }
                }
                cpu.A = w & 0xFF;
                cpu.setNZ(cpu.A);
            }
        }),
        AND(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A &= value;
                cpu.setNZ(cpu.A);
            }
        }),
        ASL(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = (value & 0x80) != 0 ? 1 : 0;
                value = 0xFE & value << 1;
                cpu.setNZ(value);
                ram.write(address, (byte)value, true);
            }
        }),
        ASL_A(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = cpu.A >> 7;
                cpu.A = 0xFE & cpu.A << 1;
                cpu.setNZ(cpu.A);
            }
        }),
        BCC(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                if (cpu.C == 0) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        BCS(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                if (cpu.C != 0) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        BEQ(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                if (cpu.Z) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        BIT(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                int result = cpu.A & value;
                cpu.Z = result == 0;
                boolean bl = cpu.N = (value & 0x80) != 0;
                if (addressMode != MODE.IMMEDIATE) {
                    cpu.V = (value & 0x40) != 0;
                }
            }
        }),
        BMI(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                if (cpu.N) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        BNE(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                if (!cpu.Z) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        BPL(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                if (!cpu.N) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        BRA(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.setProgramCounter(address);
                cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 1 : 0);
            }
        }),
        BRK(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.BRK();
                cpu.setProgramCounter(cpu.getProgramCounter() - 1);
            }
        }),
        BVC(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                if (!cpu.V) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        BVS(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                if (cpu.V) {
                    cpu.setProgramCounter(address);
                    cpu.addWaitCycles(cpu.pageBoundaryPenalty ? 2 : 1);
                }
            }
        }),
        CLC(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = 0;
            }
        }),
        CLD(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.D = false;
            }
        }),
        CLI(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.I = false;
            }
        }),
        CLV(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.V = false;
            }
        }),
        CMP(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                int val = cpu.A - value;
                cpu.C = val >= 0 ? 1 : 0;
                cpu.setNZ(val);
            }
        }),
        CPX(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                int val = cpu.X - value;
                cpu.C = val >= 0 ? 1 : 0;
                cpu.setNZ(val);
            }
        }),
        CPY(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                int val = cpu.Y - value;
                cpu.C = val >= 0 ? 1 : 0;
                cpu.setNZ(val);
            }
        }),
        DEC(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                value = 0xFF & value - 1;
                ram.write(address, (byte)value, true);
                cpu.setNZ(value);
            }
        }),
        DEA(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A = 0xFF & cpu.A - 1;
                cpu.setNZ(cpu.A);
            }
        }),
        DEX(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.X = 0xFF & cpu.X - 1;
                cpu.setNZ(cpu.X);
            }
        }),
        DEY(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.Y = 0xFF & cpu.Y - 1;
                cpu.setNZ(cpu.Y);
            }
        }),
        EOR(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A = 0xFF & (cpu.A ^ value);
                cpu.setNZ(cpu.A);
            }
        }),
        INC(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                value = 0xFF & value + 1;
                ram.write(address, (byte)value, true);
                cpu.setNZ(value);
            }
        }),
        INA(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A = 0xFF & cpu.A + 1;
                cpu.setNZ(cpu.A);
            }
        }),
        INX(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.X = 0xFF & cpu.X + 1;
                cpu.setNZ(cpu.X);
            }
        }),
        INY(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.Y = 0xFF & cpu.Y + 1;
                cpu.setNZ(cpu.Y);
            }
        }),
        JMP(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.setProgramCounter(address);
            }
        }),
        JSR(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.setProgramCounter(address, true);
            }
        }),
        LDA(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A = value;
                cpu.setNZ(cpu.A);
            }
        }),
        LDX(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.X = value;
                cpu.setNZ(cpu.X);
            }
        }),
        LDY(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.Y = value;
                cpu.setNZ(cpu.Y);
            }
        }),
        LSR(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = value & 1;
                value = value >> 1 & 0x7F;
                cpu.setNZ(value);
                ram.write(address, (byte)value, true);
            }
        }),
        LSR_A(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = cpu.A & 1;
                cpu.A = cpu.A >> 1 & 0x7F;
                cpu.setNZ(cpu.A);
            }
        }),
        NOP(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
            }
        }),
        ORA(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A |= value;
                cpu.setNZ(cpu.A);
            }
        }),
        PHA(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.push((byte)cpu.A);
            }
        }),
        PHP(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.push(cpu.getStatus());
            }
        }),
        PHX(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.push((byte)cpu.X);
            }
        }),
        PHY(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.push((byte)cpu.Y);
            }
        }),
        PLA(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A = 0xFF & cpu.pop();
                cpu.setNZ(cpu.A);
            }
        }),
        PLP(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.setStatus(cpu.pop());
            }
        }),
        PLX(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.X = 0xFF & cpu.pop();
                cpu.setNZ(cpu.X);
            }
        }),
        PLY(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.Y = 0xFF & cpu.pop();
                cpu.setNZ(cpu.Y);
            }
        }),
        ROL(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                int oldC = cpu.C;
                cpu.C = value >> 7;
                value = 0xFF & (value << 1 | oldC);
                cpu.setNZ(value);
                ram.write(address, (byte)value, true);
            }
        }),
        ROL_A(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                int oldC = cpu.C;
                cpu.C = cpu.A >> 7;
                cpu.A = 0xFF & (cpu.A << 1 | oldC);
                cpu.setNZ(cpu.A);
            }
        }),
        ROR(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                int oldC = cpu.C << 7;
                cpu.C = value & 1;
                value = 0xFF & (value >> 1 | oldC);
                cpu.setNZ(value);
                ram.write(address, (byte)value, true);
            }
        }),
        ROR_A(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                int oldC = cpu.C << 7;
                cpu.C = cpu.A & 1;
                cpu.A = 0xFF & (cpu.A >> 1 | oldC);
                cpu.setNZ(cpu.A);
            }
        }),
        RTI(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.returnFromInterrupt();
            }
        }),
        RTS(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.setProgramCounter(cpu.popWord() + 1);
            }
        }),
        SBC(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.V = ((cpu.A ^ value) & 0x80) != 0;
                int w = 0;
                if (cpu.D) {
                    int temp = 15 + (cpu.A & 0xF) - (value & 0xF) + cpu.C;
                    if (temp < 16) {
                        w = 0;
                        temp -= 6;
                    } else {
                        w = 16;
                        temp -= 16;
                    }
                    if ((w += 240 + (cpu.A & 0xF0) - (value & 0xF0)) < 256) {
                        cpu.C = 0;
                        if (cpu.V && w < 128) {
                            cpu.V = false;
                        }
                        w -= 96;
                    } else {
                        cpu.C = 1;
                        if (cpu.V && w >= 384) {
                            cpu.V = false;
                        }
                    }
                    w += temp;
                } else {
                    w = 255 + cpu.A - value + cpu.C;
                    if (w < 256) {
                        cpu.C = 0;
                        if (cpu.V && w < 128) {
                            cpu.V = false;
                        }
                    } else {
                        cpu.C = 1;
                        if (cpu.V && w >= 384) {
                            cpu.V = false;
                        }
                    }
                }
                cpu.A = w & 0xFF;
                cpu.setNZ(cpu.A);
            }
        }),
        SEC(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = 1;
            }
        }),
        SED(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.D = true;
            }
        }),
        SEI(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.I = true;
            }
        }),
        STA(true, new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                ram.write(address, (byte)cpu.A, true);
            }
        }),
        STP(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.setHalt(true);
            }
        }),
        STX(true, new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                ram.write(address, (byte)cpu.X, true);
            }
        }),
        STY(true, new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                ram.write(address, (byte)cpu.Y, true);
            }
        }),
        STZ(true, new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                ram.write(address, (byte)0, true);
            }
        }),
        TAX(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.X = cpu.A;
                cpu.setNZ(cpu.X);
            }
        }),
        TAY(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.Y = cpu.A;
                cpu.setNZ(cpu.Y);
            }
        }),
        TRB(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = (value & cpu.A) != 0 ? 1 : 0;
                ram.write(address, (byte)(value &= ~cpu.A), true);
            }
        }),
        TSB(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.C = (value & cpu.A) != 0 ? 1 : 0;
                ram.write(address, (byte)(value |= cpu.A), true);
            }
        }),
        TSX(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.X = cpu.STACK;
                cpu.setNZ(cpu.STACK);
            }
        }),
        TXA(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A = cpu.X;
                cpu.setNZ(cpu.X);
            }
        }),
        TXS(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.STACK = cpu.X;
            }
        }),
        TYA(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.A = cpu.Y;
                cpu.setNZ(cpu.Y);
            }
        }),
        WAI(new CommandProcessor(){

            public void processCommand(int address, int value, MODE addressMode) {
                cpu.waitForInterrupt();
            }
        });

        private CommandProcessor processor;
        private boolean storeOnly;

        public CommandProcessor getProcessor() {
            return this.processor;
        }

        public boolean isStoreOnly() {
            return this.storeOnly;
        }

        private COMMAND(CommandProcessor processor) {
            this(false, processor);
        }

        private COMMAND(boolean storeOnly, CommandProcessor processor) {
            this.storeOnly = storeOnly;
            this.processor = processor;
        }
    }

    private static interface CommandProcessor {
        public void processCommand(int var1, int var2, MODE var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MODE {
        IMPLIED(1, "", new AddressCalculator(){

            public int calculateAddress() {
                return -1;
            }
        }),
        RELATIVE(2, "$R", new AddressCalculator(){

            public int calculateAddress() {
                int pc = cpu.getProgramCounter();
                int address = pc + 2 + ram.read(pc + 1, false);
                cpu.setPageBoundaryPenalty((address & 0xFF00) != (pc & 0xFF00));
                return address;
            }
        }),
        IMMEDIATE(2, "#$~1", new AddressCalculator(){

            public int calculateAddress() {
                return cpu.getProgramCounter() + 1;
            }
        }),
        ZEROPAGE(2, "$~1", new AddressCalculator(){

            public int calculateAddress() {
                return ram.read(cpu.getProgramCounter() + 1, false) & 0xFF;
            }
        }),
        ZEROPAGE_X(2, "$~1,X", new AddressCalculator(){

            public int calculateAddress() {
                return 0xFF & ram.read(cpu.getProgramCounter() + 1, false) + cpu.X;
            }
        }),
        ZEROPAGE_Y(2, "$~1,Y", new AddressCalculator(){

            public int calculateAddress() {
                return 0xFF & ram.read(cpu.getProgramCounter() + 1, false) + cpu.Y;
            }
        }),
        INDIRECT(3, "$(~2~1)", new AddressCalculator(){

            public int calculateAddress() {
                int address = ram.readWord(cpu.getProgramCounter() + 1, false);
                return ram.readWord(address, true);
            }
        }),
        INDIRECT_X(3, "$(~2~1,X)", new AddressCalculator(){

            public int calculateAddress() {
                int address = ram.readWord(cpu.getProgramCounter() + 1, false) + cpu.X;
                return ram.readWord(address & 0xFFFF, true);
            }
        }),
        INDIRECT_ZP(2, "$(~1)", new AddressCalculator(){

            public int calculateAddress() {
                byte address = ram.read(cpu.getProgramCounter() + 1, false);
                return ram.readWord(address & 0xFF, true);
            }
        }),
        INDIRECT_ZP_X(2, "$(~1,X)", new AddressCalculator(){

            public int calculateAddress() {
                int address = ram.read(cpu.getProgramCounter() + 1, false) + cpu.X;
                return ram.readWord(address & 0xFF, true);
            }
        }),
        INDIRECT_ZP_Y(2, "$(~1),Y", new AddressCalculator(){

            public int calculateAddress() {
                int address = 0xFF & ram.read(cpu.getProgramCounter() + 1, false);
                address = ram.readWord(address, true) + cpu.Y;
                if ((address & 0xFF00) > 0) {
                    cpu.addWaitCycles(1);
                }
                return address;
            }
        }),
        ABSOLUTE(3, "$~2~1", new AddressCalculator(){

            public int calculateAddress() {
                return ram.readWord(cpu.getProgramCounter() + 1, false);
            }
        }),
        ABSOLUTE_X(3, "$~2~1,X", new AddressCalculator(){

            public int calculateAddress() {
                int address2 = ram.readWord(cpu.getProgramCounter() + 1, false);
                int address = 0xFFFF & address2 + cpu.X;
                if ((address & 0xFF00) != (address2 & 0xFF00)) {
                    cpu.addWaitCycles(1);
                }
                return address;
            }
        }),
        ABSOLUTE_Y(3, "$~2~1,Y", new AddressCalculator(){

            public int calculateAddress() {
                int address2 = ram.readWord(cpu.getProgramCounter() + 1, false);
                int address = 0xFFFF & address2 + cpu.Y;
                if ((address & 0xFF00) != (address2 & 0xFF00)) {
                    cpu.addWaitCycles(1);
                }
                return address;
            }
        });

        private int size;
        private String format;
        private AddressCalculator calculator;
        private boolean indirect;

        public int getSize() {
            return this.size;
        }

        public String getFormat() {
            return this.format;
        }

        public int calcAddress() {
            return this.calculator.calculateAddress();
        }

        public boolean isIndirect() {
            return this.indirect;
        }

        private MODE(int size, String fmt, AddressCalculator calc) {
            this.size = size;
            this.format = fmt;
            this.calculator = calc;
            this.indirect = this.toString().startsWith("INDIRECT");
        }

        public AddressCalculator getCalculator() {
            return this.calculator;
        }
    }

    private static interface AddressCalculator {
        public int calculateAddress();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OPCODE {
        ADC_IMM(105, COMMAND.ADC, MODE.IMMEDIATE, 2),
        ADC_ZP(101, COMMAND.ADC, MODE.ZEROPAGE, 3),
        ADC_ZP_X(117, COMMAND.ADC, MODE.ZEROPAGE_X, 4),
        ADC_AB(109, COMMAND.ADC, MODE.ABSOLUTE, 4),
        ADC_IND_ZP(114, COMMAND.ADC, MODE.INDIRECT_ZP, 5),
        ADC_IND_ZP_X(97, COMMAND.ADC, MODE.INDIRECT_ZP_X, 6),
        ADC_AB_X(125, COMMAND.ADC, MODE.ABSOLUTE_X, 4),
        ADC_AB_Y(121, COMMAND.ADC, MODE.ABSOLUTE_Y, 4),
        ADC_IND_ZP_Y(113, COMMAND.ADC, MODE.INDIRECT_ZP_Y, 5),
        AND_IMM(41, COMMAND.AND, MODE.IMMEDIATE, 2),
        AND_ZP(37, COMMAND.AND, MODE.ZEROPAGE, 3),
        AND_ZP_X(53, COMMAND.AND, MODE.ZEROPAGE_X, 4),
        AND_AB(45, COMMAND.AND, MODE.ABSOLUTE, 4),
        AND_IND_ZP(50, COMMAND.AND, MODE.INDIRECT_ZP, 5),
        AND_IND_ZP_X(33, COMMAND.AND, MODE.INDIRECT_ZP_X, 6),
        AND_AB_X(61, COMMAND.AND, MODE.ABSOLUTE_X, 4),
        AND_AB_Y(57, COMMAND.AND, MODE.ABSOLUTE_Y, 4),
        AND_IND_ZP_Y(49, COMMAND.AND, MODE.INDIRECT_ZP_Y, 5),
        ASL(10, COMMAND.ASL_A, MODE.IMPLIED, 2),
        ASL_ZP(6, COMMAND.ASL, MODE.ZEROPAGE, 5),
        ASL_ZP_X(22, COMMAND.ASL, MODE.ZEROPAGE_X, 6),
        ASL_AB(14, COMMAND.ASL, MODE.ABSOLUTE, 6),
        ASL_AB_X(30, COMMAND.ASL, MODE.ABSOLUTE_X, 7),
        BCC_REL(144, COMMAND.BCC, MODE.RELATIVE, 2),
        BCS_REL(176, COMMAND.BCS, MODE.RELATIVE, 2),
        BEQ_REL(240, COMMAND.BEQ, MODE.RELATIVE, 2),
        BIT_IMM(137, COMMAND.BIT, MODE.IMMEDIATE, 3),
        BIT_ZP(36, COMMAND.BIT, MODE.ZEROPAGE, 3),
        BIT_ZP_X(52, COMMAND.BIT, MODE.ZEROPAGE_X, 3),
        BIT_AB(44, COMMAND.BIT, MODE.ABSOLUTE, 4),
        BIT_AB_X(60, COMMAND.BIT, MODE.ABSOLUTE_X, 4),
        BMI_REL(48, COMMAND.BMI, MODE.RELATIVE, 2),
        BNE_REL(208, COMMAND.BNE, MODE.RELATIVE, 2),
        BPL_REL(16, COMMAND.BPL, MODE.RELATIVE, 2),
        BRA_REL(128, COMMAND.BRA, MODE.RELATIVE, 2),
        BRK(0, COMMAND.BRK, MODE.IMPLIED, 7),
        BVC_REL(80, COMMAND.BVC, MODE.RELATIVE, 2),
        BVS_REL(112, COMMAND.BVS, MODE.RELATIVE, 2),
        CLC(24, COMMAND.CLC, MODE.IMPLIED, 2),
        CLD(216, COMMAND.CLD, MODE.IMPLIED, 2),
        CLI(88, COMMAND.CLI, MODE.IMPLIED, 2),
        CLV(184, COMMAND.CLV, MODE.IMPLIED, 2),
        CMP_IMM(201, COMMAND.CMP, MODE.IMMEDIATE, 2),
        CMP_ZP(197, COMMAND.CMP, MODE.ZEROPAGE, 3),
        CMP_ZP_X(213, COMMAND.CMP, MODE.ZEROPAGE_X, 4),
        CMP_AB(205, COMMAND.CMP, MODE.ABSOLUTE, 4),
        CMP_IND_ZP_X(193, COMMAND.CMP, MODE.INDIRECT_ZP_X, 6),
        CMP_AB_X(221, COMMAND.CMP, MODE.ABSOLUTE_X, 4),
        CMP_AB_Y(217, COMMAND.CMP, MODE.ABSOLUTE_Y, 4),
        CMP_IND_ZP_Y(209, COMMAND.CMP, MODE.INDIRECT_ZP_Y, 5),
        CMP_IND_ZP(210, COMMAND.CMP, MODE.INDIRECT_ZP, 5),
        CPX_IMM(224, COMMAND.CPX, MODE.IMMEDIATE, 2),
        CPX_ZP(228, COMMAND.CPX, MODE.ZEROPAGE, 3),
        CPX_AB(236, COMMAND.CPX, MODE.ABSOLUTE, 4),
        CPY_IMM(192, COMMAND.CPY, MODE.IMMEDIATE, 2),
        CPY_ZP(196, COMMAND.CPY, MODE.ZEROPAGE, 3),
        CPY_AB(204, COMMAND.CPY, MODE.ABSOLUTE, 4),
        DEC(58, COMMAND.DEA, MODE.IMPLIED, 2),
        DEC_ZP(198, COMMAND.DEC, MODE.ZEROPAGE, 5),
        DEC_ZP_X(214, COMMAND.DEC, MODE.ZEROPAGE_X, 6),
        DEC_AB(206, COMMAND.DEC, MODE.ABSOLUTE, 6),
        DEC_AB_X(222, COMMAND.DEC, MODE.ABSOLUTE_X, 7),
        DEX(202, COMMAND.DEX, MODE.IMPLIED, 2),
        DEY(136, COMMAND.DEY, MODE.IMPLIED, 2),
        EOR_IMM(73, COMMAND.EOR, MODE.IMMEDIATE, 2),
        EOR_ZP(69, COMMAND.EOR, MODE.ZEROPAGE, 3),
        EOR_ZP_X(85, COMMAND.EOR, MODE.ZEROPAGE_X, 4),
        EOR_AB(77, COMMAND.EOR, MODE.ABSOLUTE, 4),
        EOR_IND_ZP(82, COMMAND.EOR, MODE.INDIRECT_ZP, 5),
        EOR_IND_ZP_X(65, COMMAND.EOR, MODE.INDIRECT_ZP_X, 6),
        EOR_AB_X(93, COMMAND.EOR, MODE.ABSOLUTE_X, 4),
        EOR_AB_Y(89, COMMAND.EOR, MODE.ABSOLUTE_Y, 4),
        EOR_IND_ZP_Y(81, COMMAND.EOR, MODE.INDIRECT_ZP_Y, 5),
        INC(26, COMMAND.INA, MODE.IMPLIED, 2),
        INC_ZP(230, COMMAND.INC, MODE.ZEROPAGE, 5),
        INC_ZP_X(246, COMMAND.INC, MODE.ZEROPAGE_X, 6),
        INC_AB(238, COMMAND.INC, MODE.ABSOLUTE, 6),
        INC_AB_X(254, COMMAND.INC, MODE.ABSOLUTE_X, 7),
        INX(232, COMMAND.INX, MODE.IMPLIED, 2),
        INY(200, COMMAND.INY, MODE.IMPLIED, 2),
        JMP_AB(76, COMMAND.JMP, MODE.ABSOLUTE, 3),
        JMP_IND(108, COMMAND.JMP, MODE.INDIRECT, 5),
        JMP_IND_X(124, COMMAND.JMP, MODE.INDIRECT_X, 6),
        JSR_AB(32, COMMAND.JSR, MODE.ABSOLUTE, 6),
        LDA_IMM(169, COMMAND.LDA, MODE.IMMEDIATE, 2),
        LDA_ZP(165, COMMAND.LDA, MODE.ZEROPAGE, 3),
        LDA_ZP_X(181, COMMAND.LDA, MODE.ZEROPAGE_X, 4),
        LDA_AB(173, COMMAND.LDA, MODE.ABSOLUTE, 4),
        LDA_IND_ZP_X(161, COMMAND.LDA, MODE.INDIRECT_ZP_X, 6),
        LDA_AB_X(189, COMMAND.LDA, MODE.ABSOLUTE_X, 4),
        LDA_AB_Y(185, COMMAND.LDA, MODE.ABSOLUTE_Y, 4),
        LDA_IND_ZP_Y(177, COMMAND.LDA, MODE.INDIRECT_ZP_Y, 5),
        LDA_IND_ZP(178, COMMAND.LDA, MODE.INDIRECT_ZP, 5),
        LDX_IMM(162, COMMAND.LDX, MODE.IMMEDIATE, 2),
        LDX_ZP(166, COMMAND.LDX, MODE.ZEROPAGE, 3),
        LDX_ZP_Y(182, COMMAND.LDX, MODE.ZEROPAGE_Y, 4),
        LDX_AB(174, COMMAND.LDX, MODE.ABSOLUTE, 4),
        LDX_AB_Y(190, COMMAND.LDX, MODE.ABSOLUTE_Y, 4),
        LDY_IMM(160, COMMAND.LDY, MODE.IMMEDIATE, 2),
        LDY_ZP(164, COMMAND.LDY, MODE.ZEROPAGE, 3),
        LDY_ZP_X(180, COMMAND.LDY, MODE.ZEROPAGE_X, 4),
        LDY_AB(172, COMMAND.LDY, MODE.ABSOLUTE, 4),
        LDY_AB_X(188, COMMAND.LDY, MODE.ABSOLUTE_X, 4),
        LSR(74, COMMAND.LSR_A, MODE.IMPLIED, 2),
        LSR_ZP(70, COMMAND.LSR, MODE.ZEROPAGE, 5),
        LSR_ZP_X(86, COMMAND.LSR, MODE.ZEROPAGE_X, 6),
        LSR_AB(78, COMMAND.LSR, MODE.ABSOLUTE, 6),
        LSR_AB_X(94, COMMAND.LSR, MODE.ABSOLUTE_X, 7),
        NOP(234, COMMAND.NOP, MODE.IMPLIED, 2),
        ORA_IMM(9, COMMAND.ORA, MODE.IMMEDIATE, 2),
        ORA_ZP(5, COMMAND.ORA, MODE.ZEROPAGE, 3),
        ORA_ZP_X(21, COMMAND.ORA, MODE.ZEROPAGE_X, 4),
        ORA_AB(13, COMMAND.ORA, MODE.ABSOLUTE, 4),
        ORA_IND_ZP(18, COMMAND.ORA, MODE.INDIRECT_ZP, 5),
        ORA_IND_ZP_X(1, COMMAND.ORA, MODE.INDIRECT_ZP_X, 6),
        ORA_AB_X(29, COMMAND.ORA, MODE.ABSOLUTE_X, 4),
        ORA_AB_Y(25, COMMAND.ORA, MODE.ABSOLUTE_Y, 4),
        ORA_IND_ZP_Y(17, COMMAND.ORA, MODE.INDIRECT_ZP_Y, 5),
        PHA(72, COMMAND.PHA, MODE.IMPLIED, 3),
        PHP(8, COMMAND.PHP, MODE.IMPLIED, 3),
        PHX(218, COMMAND.PHX, MODE.IMPLIED, 3),
        PHY(90, COMMAND.PHY, MODE.IMPLIED, 3),
        PLA(104, COMMAND.PLA, MODE.IMPLIED, 4),
        PLP(40, COMMAND.PLP, MODE.IMPLIED, 4),
        PLX(250, COMMAND.PLX, MODE.IMPLIED, 4),
        PLY(122, COMMAND.PLY, MODE.IMPLIED, 4),
        ROL(42, COMMAND.ROL_A, MODE.IMPLIED, 2),
        ROL_ZP(38, COMMAND.ROL, MODE.ZEROPAGE, 5),
        ROL_ZP_X(54, COMMAND.ROL, MODE.ZEROPAGE_X, 6),
        ROL_AB(46, COMMAND.ROL, MODE.ABSOLUTE, 6),
        ROL_AB_X(62, COMMAND.ROL, MODE.ABSOLUTE_X, 7),
        ROR(106, COMMAND.ROR_A, MODE.IMPLIED, 2),
        ROR_ZP(102, COMMAND.ROR, MODE.ZEROPAGE, 5),
        ROR_ZP_X(118, COMMAND.ROR, MODE.ZEROPAGE_X, 6),
        ROR_AB(110, COMMAND.ROR, MODE.ABSOLUTE, 6),
        ROR_AB_X(126, COMMAND.ROR, MODE.ABSOLUTE_X, 7),
        RTI(64, COMMAND.RTI, MODE.IMPLIED, 6),
        RTS(96, COMMAND.RTS, MODE.IMPLIED, 6),
        SBC_IMM(233, COMMAND.SBC, MODE.IMMEDIATE, 2),
        SBC_ZP(229, COMMAND.SBC, MODE.ZEROPAGE, 3),
        SBC_ZP_X(245, COMMAND.SBC, MODE.ZEROPAGE_X, 4),
        SBC_AB(237, COMMAND.SBC, MODE.ABSOLUTE, 4),
        SBC_IND_ZP(242, COMMAND.SBC, MODE.INDIRECT_ZP, 5),
        SBC_IND_ZP_X(225, COMMAND.SBC, MODE.INDIRECT_ZP_X, 6),
        SBC_AB_X(253, COMMAND.SBC, MODE.ABSOLUTE_X, 4),
        SBC_AB_Y(249, COMMAND.SBC, MODE.ABSOLUTE_Y, 4),
        SBC_IND_ZP_Y(241, COMMAND.SBC, MODE.INDIRECT_ZP_Y, 5),
        SEC(56, COMMAND.SEC, MODE.IMPLIED, 2),
        SED(248, COMMAND.SED, MODE.IMPLIED, 2),
        SEI(120, COMMAND.SEI, MODE.IMPLIED, 2),
        STA_ZP(133, COMMAND.STA, MODE.ZEROPAGE, 3),
        STA_ZP_X(149, COMMAND.STA, MODE.ZEROPAGE_X, 4),
        STA_AB(141, COMMAND.STA, MODE.ABSOLUTE, 4),
        STA_AB_X(157, COMMAND.STA, MODE.ABSOLUTE_X, 5),
        STA_AB_Y(153, COMMAND.STA, MODE.ABSOLUTE_Y, 5),
        STA_IND_ZP(146, COMMAND.STA, MODE.INDIRECT_ZP, 5),
        STA_IND_ZP_X(129, COMMAND.STA, MODE.INDIRECT_ZP_X, 6),
        STA_IND_ZP_Y(145, COMMAND.STA, MODE.INDIRECT_ZP_Y, 6),
        STP(219, COMMAND.STP, MODE.IMPLIED, 3),
        STX_ZP(134, COMMAND.STX, MODE.ZEROPAGE, 3),
        STX_ZP_Y(150, COMMAND.STX, MODE.ZEROPAGE_Y, 4),
        STX_AB(142, COMMAND.STX, MODE.ABSOLUTE, 4),
        STY_ZP(132, COMMAND.STY, MODE.ZEROPAGE, 3),
        STY_ZP_X(148, COMMAND.STY, MODE.ZEROPAGE_X, 4),
        STY_AB(140, COMMAND.STY, MODE.ABSOLUTE, 4),
        STZ_ZP(100, COMMAND.STZ, MODE.ZEROPAGE, 3),
        STZ_ZP_X(116, COMMAND.STZ, MODE.ZEROPAGE_X, 4),
        STZ_AB(156, COMMAND.STZ, MODE.ABSOLUTE, 4),
        STZ_AB_X(158, COMMAND.STZ, MODE.ABSOLUTE_X, 5),
        TAX(170, COMMAND.TAX, MODE.IMPLIED, 2),
        TAY(168, COMMAND.TAY, MODE.IMPLIED, 2),
        TRB_ZP(20, COMMAND.TRB, MODE.ZEROPAGE, 5),
        TRB_AB(28, COMMAND.TRB, MODE.ABSOLUTE, 6),
        TSB_ZP(4, COMMAND.TSB, MODE.ZEROPAGE, 5),
        TSB_AB(12, COMMAND.TSB, MODE.ABSOLUTE, 6),
        TSX(186, COMMAND.TSX, MODE.IMPLIED, 2),
        TXA(138, COMMAND.TXA, MODE.IMPLIED, 2),
        TXS(154, COMMAND.TXS, MODE.IMPLIED, 2),
        TYA(152, COMMAND.TYA, MODE.IMPLIED, 2),
        WAI(203, COMMAND.WAI, MODE.IMPLIED, 3);

        private int value;
        private int waitCycles;
        private COMMAND command;
        private MODE addressingMode;

        public int getValue() {
            return this.value;
        }

        public int getWaitCycles() {
            return this.waitCycles;
        }

        public COMMAND getCommand() {
            return this.command;
        }

        public MODE getMode() {
            return this.addressingMode;
        }

        public void call(int address, int value) {
            this.command.getProcessor().processCommand(address, value, this.addressingMode);
        }

        private OPCODE(int val, COMMAND c, MODE m, int wait) {
            this.value = val;
            this.waitCycles = wait - 1;
            this.command = c;
            this.addressingMode = m;
        }
    }
}

